﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class ProductCategoryBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static ProductCategory GetItem(Guid productCategoryID, string keyword)
        {
            return ProductCategoryDB.GetItem(productCategoryID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<ProductCategory> GetList(Guid productCategoryID, string keyword)
        {
            return ProductCategoryDB.GetList(productCategoryID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid productCategoryID, string keyword)
        {
            return ProductCategoryDB.GetDataTable(productCategoryID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid productCategoryID, string keyword)
        {
            return ProductCategoryDB.GetDataSet(productCategoryID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(ProductCategory myProductCategory)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                ProductCategoryDB.Save(myProductCategory);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
